#include "USB_PD.H"
void key_state()
{

    if (Flag_1ms)
    {

        Flag_1ms = 0;

        if (sel_keystate != SELECT_KEY)
        {
            sel_keystate = SELECT_KEY;

            if (sel_keystate)
            {
                //select button release
                if (SelKeyDebounce > 20)
                {
                    SEL_LED_5V = SEL_LED_9V = SEL_LED_12V = SEL_LED_15V = SEL_LED_20V = DRV_OFF;
                    Flag_select_mode = 1;
                    pd_flags &= ~PD_FLAGS_VBUS_PR_RDY;
                    select_next_mode();
                    SelKeyDebounce = Timeout_select = 0;
                }
            }
        }

        if (~sel_keystate)
        {
            //select button press
            Timeout_select = 0;

            if (SelKeyDebounce < 250)
                SelKeyDebounce++; //avoid overflow

        }
        else
            SelKeyDebounce = 0;


        if (Flag_select_mode)
        {

            if (set_keystate != SET_KEY)
            {

                set_keystate = SET_KEY;

                if (set_keystate)
                {

                    //set button release
                    if (SetKeyDebounce > 20)
                    {
                        if ((Set_volt != Select_mode) && (pd_state != PD_STATE_SNK_TRANSITION))
                        {

                            switch (Select_mode)
                            {
                                case MODE_5V :
                                    pdo_index = 0;
                                    Set_volt = MODE_5V ;
                                    break;
                                case MODE_9V :
                                    pdo_index = PDO_9V_index;
                                    Set_volt = MODE_9V;
                                    break;
                                case MODE_12V :
                                    pdo_index = PDO_12V_index;
                                    Set_volt = MODE_12V;
                                    break;
                                case MODE_15V :
                                    pdo_index = PDO_15V_index;
                                    Set_volt = MODE_15V;
                                    break;
                                case MODE_20V  :
                                    pdo_index = PDO_20V_index;
                                    Set_volt = MODE_20V;
                                    break;

                            }
                    
                            pd_new_request = 1;
                            pd_set_state(PD_STATE_SNK_REQUESTED);
                            pd_flags &= ~PD_FLAGS_VBUS_PR_RDY;
                        }
                        else
                        {
                            pd_flags |= PD_FLAGS_VBUS_PR_RDY;
                        }
                        SetKeyDebounce = 0;
                    }
                }
            }

            if (~set_keystate)
            {
                //set button press
                if (SetKeyDebounce < 250)
                    SetKeyDebounce++; //avoid overflow
            }
            else
                SetKeyDebounce = 0;

            if ((pd_flags & PD_FLAGS_VBUS_PR_RDY) != 0)
            {
  
                Flag_select_mode = 0;
            }
        }

    }
}